//
//  MCGenericBorderView.h
//  MCApplication
//
//  Created by Ali Lalani on 3/23/05.
//  Copyright 2005 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class CTGradient;

@interface MCGenericBorderView : NSView {
	BOOL drawLeftBorder;
	BOOL drawRightBorder;
	BOOL drawTopBorder;
	BOOL drawBottomBorder;
	BOOL drawTopBorderInset;

	NSColor *leftBorderColor;
	NSColor *rightBorderColor;
	NSColor *topBorderColor;
	NSColor *bottomBorderColor;
	
	CTGradient *backgroundGradient;
	NSColor *backgroundColor;
}
- (void)commonInit;

// if there is a gradient/color set, draws it. Subclassers can override
- (void)drawBackgroundInRect:(NSRect)rect;

- (BOOL)drawLeftBorder;
- (void)setDrawLeftBorder:(BOOL)flag;

- (BOOL)drawRightBorder;
- (void)setDrawRightBorder:(BOOL)flag;

- (BOOL)drawTopBorder;
- (void)setDrawTopBorder:(BOOL)flag;

- (BOOL)drawBottomBorder;
- (void)setDrawBottomBorder:(BOOL)flag;

- (BOOL)drawTopBorderInset;
- (void)setDrawTopBorderInset:(BOOL)flag;

- (NSColor *)leftBorderColor;
- (void)setLeftBorderColor:(NSColor *)aLeftBorderColor;

- (NSColor *)rightBorderColor;
- (void)setRightBorderColor:(NSColor *)aRightBorderColor;

- (NSColor *)topBorderColor;
- (void)setTopBorderColor:(NSColor *)aTopBorderColor;

- (NSColor *)bottomBorderColor;
- (void)setBottomBorderColor:(NSColor *)aBottomBorderColor;

- (void)setBackgroundGradient:(CTGradient *)aGradient;
- (CTGradient *)backgroundGradient;

- (void)setBackgroundColor:(NSColor *)aColor;
- (NSColor *)backgroundColor;


@end
